#if !defined(PLAYER_HPP)
#define PLAYER_HPP

#include "chess.hpp"

enum GAMESTATUS { GAMECONTINUE, GAMEOVER };

// abstract base class for player.  a player performs a move
// when the play member is invoked.
class PLAYER
  {
  private:
    const PIECECOLOR color;

  public:
    PLAYER(PIECECOLOR c) : color(c) { }

    PIECECOLOR whatColor(void) const { return(color); }

    virtual GAMESTATUS play(BOARD &board) const = 0;

  };

#endif
